/*
 * clientsocket.c -- DHCP client socket creation
 *
 * udhcp client
 *
 * Russ Dill <Russ.Dill@asu.edu> July 2001
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netinet/in.h>
#include <features.h>
#if __GLIBC__ >=2 && __GLIBC_MINOR >= 1
#include <netpacket/packet.h>
#include <net/ethernet.h>
#else
#include <asm/types.h>
#include <linux/if_packet.h>
#include <linux/if_ether.h>
#endif

#include "clientsocket.h"
#include "common.h"


int raw_socket(int ifindex)
{
  int fd;
  struct sockaddr_ll sock;

  DEBUG(LOG_INFO, "Opening raw socket on ifindex %d", ifindex);
  if ((fd = socket(PF_PACKET, SOCK_DGRAM, htons(ETH_P_IP))) < 0) {
    DEBUG(LOG_ERR, "socket call failed: %m");
    return -1;
  }

  sock.sll_family = AF_PACKET;
  sock.sll_protocol = htons(ETH_P_IP);
  sock.sll_ifindex = ifindex;
  if (bind(fd, (struct sockaddr *) &sock, sizeof(sock)) < 0) {
    DEBUG(LOG_ERR, "bind call failed: %m");
    close(fd);
    return -1;
  }

  return fd;
}
